 <?php $__env->startSection('content'); ?>
<div class="content-wrapper">
	<div class="content pt-3">
		<div class="container-fluid">
			<div class="row">
				<div class="col-12">
					<div class="card border-0 shadow-custom">
						<div class="card-header border-grey">
							<h3 class="card-title">
								<?php echo e(__('notification.expired_title')); ?>

							</h3>
						</div>
						<div class="card-body">
							<div class="row">
								<div class="col-md-12 d-flex justify-content-end">
									<form method="post" action="<?php echo e(route('member.expired')); ?>">
										<?php echo e(csrf_field()); ?>

										<div class="input-group mb-3">
											<input type="text" name="search" class="form-control" placeholder="Search"
												required />
											<div class="input-group-append">
												<button class="btn btn-primary" type="submit">
													<i class="fas fa-search"></i>
												</button>
											</div>
										</div>
									</form>
								</div>
								<div class="col-12">
									<div class="table-responsive">
										<table class="table custom-table-bordered table-hover">
											<thead>
												<tr>
													<th class="nowrap"><?php echo e(__('notification.th_reg_no')); ?></th>
													<th><?php echo e(__('notification.th_name')); ?></th>
													<th><?php echo e(__('notification.th_phone')); ?></th>
													<th class="nowrap"><?php echo e(__('notification.th_membership_type')); ?></th>
													<th class="nowrap"><?php echo e(__('notification.th_valid_from')); ?></th>
													<th class="nowrap"><?php echo e(__('notification.th_valid_to')); ?></th>
													<th class="nowrap"><?php echo e(__('notification.th_amount')); ?></th>
													<th class="nowrap"><?php echo e(__('notification.th_paid')); ?></th>
													<th class="nowrap"><?php echo e(__('notification.th_due')); ?></th>
													<th class="nowrap"><?php echo e(__('notification.th_payment_status')); ?></th>
													<th class="fixed-width-td"><?php echo e(__('notification.th_action')); ?></th>
												</tr>
											</thead>
											<tbody>
												<?php $__currentLoopData = $memberships; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $membership): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<tr>
													<td class="align-middle">
														<?php echo e($membership->reg_no); ?>

													</td>
													<td class="align-middle nowrap">
														<?php echo e($membership->name); ?>

													</td>
													<td class="align-middle">
														<?php echo e($membership->phone); ?>

													</td>
													<td class="align-middle nowrap">
														<?php echo e($membership->membership_name); ?>

													</td>
													<td class="align-middle nowrap">
														<?php echo e(format_date($membership->valid_from)); ?>

													</td>
													<td class="align-middle nowrap">
														<?php echo e(format_date($membership->valid_to)); ?>

													</td>
													<td class="align-middle nowrap">
														<?php echo e(currency_symbol()); ?>

														<?php echo e(round_off($membership->actual_amount)); ?>

													</td>
													<td class="align-middle nowrap">
														<?php echo e(currency_symbol()); ?>

														<?php echo e(round_off($membership->total_paid)); ?>

													</td>
													<td class="align-middle nowrap">
														<?php echo e(currency_symbol()); ?>

														<?php echo e(round_off($membership->due_amount)); ?>

													</td>
													<td class="align-middle nowrap">
														<?php echo payment_status($membership->actual_amount,
														$membership->total_paid); ?>

													</td>
													<td>
														<div class="d-flex">
															<a href="<?php echo e(route('membership.create', $membership->member_id)); ?>"
																type="button" class="btn btn-success mr-2">
																<i class="fa fa-plus"></i>
															</a>
															<a href="<?php echo e(route('member.edit', $membership->member_id)); ?>"
																type="button" class="btn btn-warning">
																<i class="fa fa-user"></i>
															</a>
														</div>
													</td>
												</tr>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												<?php if(count($memberships) == 0): ?>
												<tr>
													<td colspan="11">
														<p class="text-center mb-0">
															<?php echo e(__('notification.no_record_found')); ?>

														</p>
													</td>
												</tr>
												<?php endif; ?>
											</tbody>
										</table>
									</div>
								</div>
								<div class="col-12">
									<div class="d-flex justify-content-end">
										<?php if($paginate): ?>
										<?php echo e($memberships->links()); ?>

										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/resources/views/alert/expired_members.blade.php ENDPATH**/ ?>